package org.codefilarete.stalactite.sql.ddl;

import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;

public class H2DDLTableGenerator extends DDLTableGenerator {
	
	public H2DDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProviderFactory dmlNameProviderFactory) {
		super(typeMapping, dmlNameProviderFactory);
	}
	
	@Override
	protected String getSqlType(Column column) {
		String sqlType = super.getSqlType(column);
		if (column.isAutoGenerated()) {
			sqlType += " GENERATED ALWAYS AS IDENTITY";
		}
		return sqlType;
	}
	
	/**
	 * Overridden to implement H2 "unique" keyword
	 */
	@Override
	protected void generateCreatePrimaryKey(PrimaryKey primaryKey, DDLAppender sqlCreateTable) {
		sqlCreateTable.cat(", unique (")
				.ccat(primaryKey.getColumns(), ", ")
				.cat(")");
	}
}
